import { StarXpandCommand } from "star-io10-web";

export class LabelSample18_For203dpiAnd300dpi_BarcodeLabel2_Wide_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 72.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(72.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleBold(true)
            .actionPrintText("${product_name}\n")
            .styleBold(false)
            .actionPrintText(
              "${parameter1} / ${parameter2} / ${parameter3} / ${parameter4}\n",
            )
            .actionPrintBarcode(
              new StarXpandCommand.Printer.BarcodeParameter(
                "${sku}",
                StarXpandCommand.Printer.BarcodeSymbology.UpcA,
              )
                .setBarDots(3)
                .setHeight(12.0)
                .setPrintHri(true),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "product_name" : "Product Name",
    "parameter1" : "SKU",
    "parameter2" : "Price",
    "parameter3" :  "Variant option 1",
    "parameter4" : "Incl. VAT",
    "sku" : "012345789012"
}`,
    );
  }
}
